## 1. General Overview

StockPro is a modern and comprehensive inventory management application designed to operate **entirely offline**. It is intended for retailers, warehouses, hardware stores, wholesalers, pharmacies, resellers, and any business wishing to effectively track, control, and analyze its items, transactions, and stock levels.

The application emphasizes ease of use while offering powerful functionality adapted to real-world situations. StockPro allows you to manage multiple stores, customize the currency used, generate detailed reports, print transactions, and reliably export data.

It is suitable for both novice users and demanding professionals seeking advanced control, robust traceability, and a clear overview of their business.

---

## 2. Main Application Pages

### Home

The home page presents the most common actions in the form of cards or quick buttons. The user can quickly:

- Add a new item
- Record an incoming or outgoing transaction
- View the item list
- Create or view an inventory
- Print a transaction slip

This page serves as a quick access point to essential functions. Depending on the user's role, additional shortcuts (reports, profit, inventory, etc.) may appear here.

---

### My Stores

This page allows you to create, modify, or delete stores.

Each store functions as a completely isolated environment.

Features:

- Add a store with name, currency, and description
- List of existing stores
- Quickly switch to the active store
- Complete isolation of items, transactions, and reports

---

### Items

Displays the list of all items registered for the current store.

Each item contains:

- Name
- Category
- Current quantity in stock
- Purchase price and selling price
- Minimum stock level
- Packaging method (if enabled)

Available functions:

- Add item (manually or in bulk)
- Quickly modify prices and quantities
- Secure deletion
- Smart search
- Export to Excel

---

### Categories

The Categories page allows you to classify items by product family to facilitate analysis and reporting.

Available actions:

- Add, edit, or delete a category
- View the number of items per category
- Export items from selected categories

---

### Partners

Groups **customers and suppliers**.

A partner can be a customer, a supplier, or both.

Features:

- Adding and modifying partners
- History of related transactions
- Tracking balances (unpaid invoices or advances – Pro License)

---

### Transactions

The Transactions page displays all stock entries and exits.

Each line contains:

- Item concerned
- Type (entry or exit)
- Quantity
- Date
- Total amount
- Payment status (if enabled)

Available actions:

- Adding a transaction
- Deleting a transaction with automatic stock adjustment
- Printing (simple invoice)
- Advanced search

---

### Inventory (Reconciliation)

The Inventory page allows you to **compare the actual physical stock with the stock recorded in the system**.

How it works:

- The user enters the actual quantities observed.
- StockPro automatically calculates discrepancies (plus/minus).
- An inventory report is generated.
- Stock can be adjusted to reflect reality.

Features:

- Creation of control inventories.
- History of past inventories.
- Discrepancy reports.
- Automatic stock adjustment.

---

### Reports

Accessible to manager or administrator users.

Available reports:

- Current stock value.
- Stock change by category.
- Gross monthly profit.
- Inventory discrepancies.
- Best-selling items.
- Most profitable items.
- Outstanding and partial payments (Pro License).

---

### Settings

Contains all customization and administration options.

Features:

- Data backup and restore
- Currency selection
- Language (French / English)
- Theme (light / dark)
- License management
- **Local Area Network (LAN) mode**:

- Server mode (main workstation)

- Client mode (other workstations on the network)
- Software information

---

## 3. Key Features in Detail

### Managing Items with Packaging (Wholesale / Retail)

StockPro allows you to manage items sold or purchased in **wholesale and retail** without disrupting your inventory logic.

Principle:

- One **basic unit** (e.g., piece)
- One or more **packaging options** (e.g., carton = 24 pieces)

Advantages:

- Retail or wholesale sales
- Inventory always calculated in basic units
- Consistent reports
- No duplicate items

---

### Partial Payments (Pro License)

Transactions can be processed Partially paid.

How it works:

- Stock is updated immediately
- Payment can be full, partial, or deferred
- The remaining balance is automatically tracked
- Unpaid items appear in reports

---

### Multi-store

This feature allows you to completely separate the activities of multiple stores. Items, transactions, and reports **never cross paths between stores**.

---

### Local Area Network (LAN) Mode

Allows multiple computers to use StockPro on the same local network.

How it works:

- A server centralizes the data
- Client workstations access the data in real time
- No internet connection required

---

### Cloud Sync (read-only)

Using a complementary tool (**StockPro Cloud Sync**), certain data can be synchronized to the cloud for **remote viewing on mobile**.

⚠️ No modifications are possible from the mobile device.

---

### Backup and Restore

- Local Database Backup
- Backup History
- One-Click Restore

---

### Licensing System

StockPro offers:

- **30-Day Free Trial**
- **Standard License**:

- 1 Store

- Essential Features
- **Professional License**:

- Multi-Store
- Partial Payments
- Advanced Reporting
- Network Mode

Licenses are verified locally, without an internet connection.

---

## 4. Common Problems and Solutions

### ❌ Application Won't Launch

Install `vc_redist.x64.exe`.

### ❓ Forgot Password

Reset by administrator or temporary master code.

### ⚠️ Printing Not Working

Check the default printer or PDF folder.

### ℹ️ Profit appears to be incorrect

**Explanation**: Profit is calculated as the difference between the selling price and the purchase price of items **actually sold** during the month. It does not take into account expenses (salaries, transportation, etc.).

---

This manual will be updated with StockPro.

Support: **<tiwabrayan+stockpro@gmail.com>**
