## 1. Présentation générale

StockPro est une application de gestion de stock moderne et complète, conçue pour fonctionner **entièrement hors ligne**. Elle s’adresse aux commerçants, dépôts, quincailleries, grossistes, pharmacies, revendeurs, et à toute entreprise souhaitant suivre, contrôler et analyser efficacement ses articles, ses opérations et ses niveaux de stock.

L’application met l’accent sur la simplicité d’utilisation tout en offrant une puissance fonctionnelle adaptée aux réalités du terrain. StockPro permet de gérer plusieurs boutiques, de personnaliser la devise utilisée, de générer des rapports détaillés, d’imprimer des opérations et d’exporter les données de manière fiable.

Elle convient aussi bien aux utilisateurs débutants qu’aux professionnels exigeants recherchant un contrôle avancé, une bonne traçabilité et une vision claire de leur activité.

---

## 2. Pages principales de l’application

### Accueil

La page d’accueil présente les actions les plus courantes sous forme de cartes ou de boutons rapides. L’utilisateur peut rapidement :

- Ajouter un nouvel article  
- Enregistrer une opération d’entrée ou de sortie  
- Consulter la liste des articles  
- Créer ou consulter un inventaire  
- Imprimer une fiche d’opération  

Cette page sert de point d’accès rapide aux fonctions essentielles. Selon le rôle de l’utilisateur, des raccourcis supplémentaires (rapports, bénéfice, inventaire, etc.) peuvent y apparaître.

---

### Mes boutiques

Cette page permet de créer, modifier ou supprimer des boutiques.  
Chaque boutique fonctionne comme un environnement totalement isolé.

Fonctionnalités :

- Ajout d’une boutique avec nom, devise et description
- Liste des boutiques existantes
- Bascule rapide vers la boutique active
- Isolation complète des articles, opérations et rapports

---

### Articles

Affiche la liste de tous les articles enregistrés pour la boutique en cours.

Chaque article contient :

- Nom
- Catégorie
- Quantité actuelle en stock
- Prix d’achat et prix de vente
- Seuil de stock minimum
- Mode de conditionnement (si activé)

Fonctions disponibles :

- Ajout d’article (manuel ou en masse)
- Modification rapide des prix et quantités
- Suppression sécurisée
- Recherche intelligente
- Exportation vers Excel

---

### Catégories

La page Catégories permet de classer les articles par familles de produits afin de faciliter l’analyse et les rapports.

Actions disponibles :

- Ajouter, modifier ou supprimer une catégorie
- Visualiser le nombre d’articles par catégorie
- Exporter les articles des catégories sélectionnées

---

### Partenaires

Regroupe les **clients et fournisseurs**.  
Un partenaire peut être client, fournisseur ou les deux.

Fonctionnalités :

- Ajout et modification des partenaires
- Historique des opérations liées
- Suivi des soldes (impayés ou avances – Licence Pro)

---

### Opérations

La page Opérations affiche toutes les entrées et sorties de stock.

Chaque ligne contient :

- Article concerné
- Type (entrée ou sortie)
- Quantité
- Date
- Montant total
- Statut de paiement (si activé)

Actions disponibles :

- Ajout d’opération
- Suppression avec réajustement automatique du stock
- Impression (facture simple)
- Recherche avancée

---

### Inventaires (Rapprochement)

La page Inventaires permet de **comparer le stock physique réel avec le stock enregistré dans le système**.

Fonctionnement :

- L’utilisateur saisit les quantités réellement observées
- StockPro calcule automatiquement les écarts (plus / moins)
- Un rapport d’inventaire est généré
- Le stock peut être ajusté pour refléter la réalité

Fonctionnalités :

- Création d’inventaires de contrôle
- Historique des inventaires passés
- Rapports d’écarts
- Ajustement automatique du stock

---

### Rapports

Accessible aux utilisateurs manager ou administrateur.

Rapports disponibles :

- Valeur actuelle du stock
- Évolution du stock par catégorie
- Bénéfice mensuel brut
- Écarts d’inventaire
- Articles les plus vendus
- Articles les plus rentables
- Impayés et paiements partiels (Licence Pro)

---

### Paramètres

Regroupe toutes les options de personnalisation et d’administration.

Fonctionnalités :

- Sauvegarde et restauration des données
- Choix de la devise
- Langue (Français / Anglais)
- Thème (clair / sombre)
- Gestion de la licence
- **Mode réseau local (LAN)** :
  - Mode Serveur (poste principal)
  - Mode Client (autres postes du réseau)
- Informations sur le logiciel

---

## 3. Fonctionnalités clés en détail

### Gestion des articles avec conditionnement (Gros / Détail)

StockPro permet de gérer des articles vendus ou achetés en **gros et en détail** sans casser la logique du stock.

Principe :

- Une **unité de base** (ex : pièce)
- Un ou plusieurs **conditionnements** (ex : carton = 24 pièces)

Avantages :

- Vente en détail ou en gros
- Stock toujours calculé en unité de base
- Rapports cohérents
- Aucun doublon d’article

---

### Paiements partiels (Licence Pro)

Les opérations peuvent être réglées **partiellement**.

Fonctionnement :

- Le stock est mis à jour immédiatement
- Le paiement peut être total, partiel ou différé
- Le solde restant est automatiquement suivi
- Les impayés apparaissent dans les rapports

---

### Multi-boutiques

Cette fonctionnalité permet de séparer totalement les activités de plusieurs magasins.  
Les articles, opérations et rapports **ne se croisent jamais entre boutiques**.

---

### Mode réseau local (LAN)

Permet à plusieurs ordinateurs d’utiliser StockPro sur un même réseau local.

Principe :

- Un poste serveur centralise les données
- Les postes clients accèdent aux données en temps réel
- Aucun Internet requis

---

### Cloud Sync (lecture seule)

Grâce à un outil complémentaire (**StockPro Cloud Sync**), certaines données peuvent être synchronisées vers le cloud pour une **consultation à distance sur mobile**.

⚠️ Aucune modification n’est possible depuis le mobile.

---

### Sauvegarde et restauration

- Sauvegarde locale de la base de données
- Historique des sauvegardes
- Restauration en un clic

---

### Système de licence

StockPro propose :

- **30 jours d’essai gratuit**
- **Licence Standard** :
  - 1 boutique
  - Fonctionnalités essentielles
- **Licence Professionnelle** :
  - Multi-boutiques
  - Paiements partiels
  - Rapports avancés
  - Mode réseau

Les licences sont vérifiées localement, sans Internet.

---

## 4. Problèmes fréquents et solutions

### ❌ L’application ne se lance pas

Installer `vc_redist.x64.exe`.

### ❓ Mot de passe oublié

Réinitialisation par l’administrateur ou code maître temporaire.

### ⚠️ Impression non fonctionnelle

Vérifier l’imprimante par défaut ou le dossier PDF.

### ℹ️ Le bénéfice semble incorrect

**Explication** : Le bénéfice est calculé comme la différence entre le prix de vente et le prix d’achat des articles **effectivement sortis** pendant le mois. Il ne prend pas en compte les charges (salaires, transport, etc.).

---

Ce manuel évoluera avec StockPro.  
Support : **<tiwabrayan+stockpro@gmail.com>**
